// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Stewart Berry - Caliper Corporation - 2003

    // This toolbox creates a circle (ellipse annotation) of a user specified diameter 
    // at a clicked point
    
    // The toolbox illustrates how to:
    // 1. Add tools to a toolbox.
    // 2. Use GISDK functions such as the annotation and style functions
    // 3. Use user input to perform tasks

    // To run this toolbox using the GISDK toolbox:
    // 1. Open or make current the map that you want to use.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this toolbox in test mode using the first button (Compile).
    // 4. Run this toolbox by clicking the second button (Test), typing the dbox 
    //    name "circle", clicking the Dialog Box radio button, and clicking OK.

dBox "circle" toolbox

    // Initialize
    Init do
        runmacro("init_macro")        
        endItem

    Close do
        // On close terminate the execution of the dialog box and close its window 
        Return()
        enditem

    Tool "Circle"  after, same 
        // Set the tool icons, cursor type, and Help information
        icons: "bmp\\buttons.bmp|211", "bmp\\buttons.bmp|245", "bmp\\buttons.bmp|279" 
        cursor: "arrow"
        help: "Double click on a map window to add a circle."
        do
            // Some initalization code
            runmacro("init_macro")
            // Special error handling
            on escape do Return() end
            on error do Return() end
            // Wait for the user to click
            c = ClickCoord()
            // Run the dbox to get the diameter
            r = RunDbox("rad")
            if r = null then do
                showmessage("You must enter a diameter.")
                goto skip
                end
            // Set the style of the circle (the programmer could change this)
            str2 = "        "
            solid = FillStyle({str2, str2, str2, str2, str2, str2, str2, str2})
            solid_line = LineStyle({{{1, -1, 0}}})
            // Use the user diameter to compute the actual geographical diameter
            dist1 = r/ Cos(c.lat / 1000000/180*3.1415927)
            dist2 = dist1 * Cos(c.lat / 1000000/180*3.1415927)

            // Create a scope for the circle
            scp = Scope(c, dist1, dist2, )

            // Add an ellipse annotation with specified styles and scope
            option_array = { 
                { "Location" , scp } ,
                { "Fill Color",ColorRGB(0,0,0)}, 
                { "Fill Style",solid}, 
                { "Line Color", ColorRGB(0,0,65535)},
                { "Line Style",solid_line}, 
                { "Line Width",0}}
            annotation_id = AddAnnotation(window_name,"Ellipse",option_array)
                
            // Redraw all annotations in a window
            DrawMapAnnotations(window_name)
           skip:
            
            // Cancels special error handling
            on escape default
            on error default
        enditem

    macro "init_macro" do
        // Make sure there is a map, and get the map and window names
        if getmap() = null then do
            showmessage("Please open a map.")
            return()
            end
        map = GetMap()
        window_name = "Map|" + map
    endItem

endDbox

Dbox "rad" title: "Enter Diameter"
    
    // Initialise
    Init do
        mu = GetMapUnits("Abbreviation")
        endItem
    
    // Edit text item for user input of diameter
    Edit Real "rad" 7.5, .5, 19 prompt: "Diameter"  variable: diameter 
    Text 27, .5, 3 variable: mu
    
    // Buttons that return based on user input
    Button "OK" 4, 2.5, 8 default do Return(diameter) endItem
    Button "Cancel" 18, 2.5, 8 cancel do Return(null) endItem

endDbox